<?php

namespace Inside\Archive\Providers;

use Inside\Support\EventServiceProvider;
use Inside\Archive\Console\ArchiveContents;
use Inside\Archive\Http\Middlewares\ArchiveFormMiddleware;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

class ArchiveServiceProvider extends EventServiceProvider
{
    protected array $commands = [
        ArchiveContents::class,
    ];

    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigFrom(__DIR__.'/../../config/archive.php', 'archive');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }

        $this->app->middleware(
            [
                ArchiveFormMiddleware::class,
            ]
        );
    }
}
