<?php

namespace Inside\Archive\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Builder;

/**
 * @method static Builder query()
 * @method static Builder where($column, $operator = null, $value = null, $boolean = 'and')
 *
 * @property string $date
 * @property string $uuid
 * @property string $type
 */
class Archive extends Model
{
    /**
     * @var string
     */
    public $primaryKey = 'uuid';

    /**
     * The table without the timestamps.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_archives';

    /**
     * The attributes that are fillable
     *
     * @var array
     */
    protected $fillable = [
        'type',
        'uuid',
        'date',
    ];

    /**
     * @var array
     */
    protected $casts = ['uuid' => 'string'];
}
