<?php

namespace Inside\Archive\Console;

use Illuminate\Console\Command;
use Inside\Archive\Models\Archive;
use Inside\Host\Bridge\BridgeContent;

class ArchiveContents extends Command
{
    /**
     * @var string
     */
    protected $name = 'inside:archive-contents';

    /**
     * @var string
     */
    protected $signature = 'inside:archive-contents';

    /**
     * @var string
     */
    protected $description = 'Archive contents';

    /**
     * Handle index command
     *
     * @throws \Exception
     * @return void
     */
    public function handle(): void
    {
        $bridge = new BridgeContent();
        $archives = Archive::query()->where('date', 'like', date('Y-m-d') . '%')->get();

        $archives->each(function (Archive $archive) use ($bridge) {
            $content = call_user_func($archive->type . '::find', $archive->uuid);

            if (!$content) {
                $archive->delete();
                return;
            }

            $bridge->setStatus($content, false);
        });
    }
}
