<?php

use Illuminate\Support\Facades\Schema;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class InstallArchives extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('inside_archives')) {
            Schema::create('inside_archives', function (Blueprint $table) {
                $table->string('type');
                $table->uuid('uuid');
                $table->datetime('date')->nullable();
            });

            Schema::table(
                'inside_archives',
                function (Blueprint $table) {
                    $table->index(['uuid', 'type']);
                    $table->index(['date']);
                }
            );
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('inside_archives');
    }
}
