<?php

namespace Inside\Archive\Jobs;

use Inside\Archive\Models\Archive;
use Inside\Host\Bridge\BridgeContent;
use Inside\Jobs\Job;

class DeleteContent extends Job
{
    public function __construct(
        protected array $content
    ) {
    }

    public function handle(): void
    {
        $content = call_user_func($this->content['type'].'::find', $this->content['uuid']);
        Archive::where('type', $this->content['type'])->where('uuid', $this->content['uuid'])->delete();

        if (is_null($content)) {
            return;
        }

        $bridge = new BridgeContent();

        $bridge->contentDelete(class_to_type($this->content['type']), $this->content['uuid']);
    }
}
