<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Settings\Models\Setting;

final class AddArchiveContentsSettings extends Migration
{
    public function up(): void
    {
        $contentTypes = array_values(array_diff(
            InsideSchema::getContentTypes(),
            array_merge(InsideSchema::getCategorizableContentTypes(), config('archive.excludeContentTypes')),
            [
                'users',
                'newsletters',
                'comments',
                'statistics',
                'reactions',
                'tools_menu',
                'footer_menus',
                'main_menus',
                'shortcuts_menus'
            ]
        ));

        Setting::updateOrCreate(['key' => 'default_setting', 'group' => 'contentManagement'], ['value' => config('archive.enabled') ? '1' : null]);
        Setting::updateOrCreate(['key' => 'archived_content_types', 'group' => 'contentManagement'], ['value' => json_encode($contentTypes, JSON_UNESCAPED_UNICODE)]);
    }
}
