<?php

namespace Inside\Form\Advanced\Services;

use Illuminate\Support\Facades\Log;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Content;
use Inside\Host\Bridge\BridgeContent;

class AdvancedFormSubmissionService
{
    private const CONTENT_TYPE = 'advanced_form_submissions';

    public function deleteAdvancedFormSubmissionsByAdvancedFormUuid(
        string $advancedFormUuid
    ): void {
        $bridge = new BridgeContent();
        $contentType = 'advanced_form_submissions';
        $contents = type_to_class(self::CONTENT_TYPE)::query()
            ->whereHas('advancedForms', fn ($query) => $query->where('uuid', $advancedFormUuid))
            ->orWhereDoesntHave('advancedForms')
            ->get();

        if ($contents->isEmpty()) {
            Log::warning("No advanced form submissions found for advanced form UUID: {$advancedFormUuid}");
        } else {
            Log::warning("Found {$contents->count()} advanced form submissions for advanced form UUID: {$advancedFormUuid}");
        }

        $contents->each(fn (Content $content) => $bridge->contentDelete(self::CONTENT_TYPE, (string) $content->uuid));
    }
}
