<?php

namespace Inside\Form\Advanced\Http\Middlewares;

use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class Search
{
    public function content(Request $request, Response $response, array $roles): array
    {
        $content = json_decode_response($response);

        if (empty($content['data']) || collect($content['data'])->isEmpty()) {
            return $content;
        }

        if (!in_array($content['data'][0]['content_type'], [
            'advanced_forms',
            'advanced_form_submissions',
        ])) {
            return $content;
        }

        $filteredData = [];
        foreach ($content['data'] as $index => $data) {
            $adminRoles = $data['content_type'] === 'advanced_form_submissions' ?
                data_get($data, 'advanced_forms.admin_roles', "") :
                data_get($data, 'admin_roles', "");

            $adminRolesArray = explode(',', $adminRoles);
            if (
                empty($adminRoles) || !empty(array_intersect($roles, $adminRolesArray))
            ) {
                $filteredData[] = $data;
            }
        }
        $content['data'] = $filteredData;

        return $content;
    }
}
