<?php

namespace Inside\Form\Advanced\Http\Middlewares;

use Illuminate\Http\Request;
use Illuminate\Support\Collection;
use Symfony\Component\HttpFoundation\Response;

class AdvancedFormSubmissions
{
    public function content(Request $request, Response $response, array $roles): array
    {
        $content = json_decode_response($response);

        if (collect($content['data'])->isEmpty()) {
            return $content;
        }

        $filteredData = [];
        foreach ($content['data'] as $index => $data) {
            $adminRoles = data_get($data, 'advanced_forms.admin_roles', "");
            $adminRolesArray = explode(',', $adminRoles);
            if (
                empty($adminRoles) ||
                !empty(array_intersect($roles, $adminRolesArray))
            ) {
                $filteredData[] = $data;
            }
        }
        $content['data'] = $filteredData;

        return $content;
    }
}
