<?php

namespace Inside\Form\Advanced\Http\Controllers;

use Illuminate\Support\Facades\Storage;
use Inside\Kernel\Filesystem\Facades\FileStreamer;
use Laravel\Lumen\Routing\Controller;
use Symfony\Component\HttpFoundation\StreamedResponse;

final class DownloadFile extends Controller
{
    public function download(string $extension, string $filename): StreamedResponse
    {
        $fullFilename = "exports/advanced-forms/{$filename}.{$extension}";
        $disk = Storage::disk('local');

        if ($disk->exists($fullFilename)) {
            return FileStreamer::streamFile($fullFilename);
        }

        throw new \Exception('File missing');
    }
}
