<?php

namespace Inside\Form\Advanced\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Inside\Form\Advanced\Http\Requests\ExportSubmissionsRequest;
use Inside\Form\Advanced\Http\Requests\SubmissionsRequest;
use Inside\Form\Advanced\Http\Requests\UpdateSubmissionStatusRequest;
use Inside\Form\Advanced\Http\Requests\DeleteSubmissionsRequest;
use Inside\Form\Advanced\Jobs\GenerateAdvancedFormsExport;
use Inside\Form\Advanced\Services\AdvancedFormService;
use Inside\Form\Advanced\Services\AdvancedFormsExportService;
use Laravel\Lumen\Routing\Controller;

class AdvancedFormController extends Controller
{
    public function __construct(private AdvancedFormService $service)
    {
    }

    public function batchUpdateSubmissionStatus(UpdateSubmissionStatusRequest $request): JsonResponse
    {
        $submissionStatus = $request->get('submission_status');
        $uuids = $request->get('uuids', []);

        $success = $this->service->batchUpdateSubmissionStatus($submissionStatus, $uuids);
        return response()->json([
            'success' => $success,
            'code' => $success ? 200 : 400
        ]);
    }

    public function batchDeleteSubmissions(DeleteSubmissionsRequest $request): JsonResponse
    {
        $uuids = $request->get('uuids', []);

        $success = $this->service->batchDeleteSubmissions($uuids);
        return response()->json([
            'success' => $success,
            'code' => $success ? 200 : 400
        ]);
    }

    public function submissionsCount(SubmissionsRequest $request): JsonResponse
    {
        $advancedFormUuid = $request->get('uuid');
        $userUuid = $request->user()->uuid;

        $count = $this->service->getSubmissionsCountFormAdvancedForm($advancedFormUuid, $userUuid);

        return response()->json([
            'count' => $count,
            'code' => 200
        ]);
    }

    public function exportSubmissions(ExportSubmissionsRequest $request): JsonResponse
    {
        $uuids = $request->get('uuids', []);

        (new GenerateAdvancedFormsExport($uuids, optional($request->user())->id))->handle(
            app(AdvancedFormsExportService::class)
        );

        /*GenerateAdvancedFormsExport::dispatch(
            submissionUuids: $uuids,
            userId: optional($request->user())->id
        );*/

        return response()->json([
            'status' => 'queued',
            'message' => 'Export planifié. Vous recevrez une notification quand il sera prêt.'
        ], 202);
    }
}
