<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Migrations\CreateContentTypes;

final class MakeAdvancedFormsPermissible extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);
        $this->getBridge()?->contentTypeUpdate('advanced_forms', [
            'permissible' => true
        ]);
        $this->finishUp();
    }
}
