<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class AdvancedFormsNotificationTypes extends Migration
{
    public function up(): void
    {
        NotificationType::firstOrCreate(
            [
                'via'     => 'web',
                'default' => true,
                'event'   => '',
                'model'   => 'Inside\Content\Models\Contents\AdvancedForms',
                'type'    => 'system',
                'action'  => 'advanced-form-submitted',
                'condition' => null,
                'multiple'  => false,
                'language'  => true,
                'profile'   => false,
            ],
            [
                'data' => [
                    'title'       => 'notifications.advanced.form.submit.title',
                    'description' => 'notifications.advanced.form.submit.description',
                    'icon'        => '',
                    'text'        => 'notifications.advanced.form.submit.text',
                ],
            ]
        );

        NotificationType::firstOrCreate(
            [
                'via'     => 'email',
                'default' => true,
                'event'   => '',
                'model'   => 'Inside\Content\Models\Contents\AdvancedForms',
                'type'    => 'system',
                'action'  => 'advanced-form-submitted',
                'condition' => null,
                'multiple'  => false,
                'language'  => true,
                'profile'   => false
            ],
            [
                'data' => [
                    'title'       => 'notifications.advanced.form.submit.mail.title',
                    'description' => 'notifications.advanced.form.submit.mail.description',
                    'mail' => [
                        'text'        => 'notifications.advanced.form.submit.mail.text',
                        'subject'     => 'notifications.advanced.form.submit.mail.subject',
                        'buttonText'  => 'notifications.advanced.form.submit.mail.buttonText',
                    ]
                ],
            ]
        );

        // B) Changement de statut (web + email)
        foreach ([
                     ['key' => 'accepted', 'cond' => 'submission_status:accepted'],
                     ['key' => 'rejected',  'cond' => 'submission_status:rejected'],
                     ['key' => 'pending',  'cond' => 'submission_status:pending'],
                 ] as $v) {
            NotificationType::firstOrCreate(
                [
                    'via'       => 'web',
                    'default'   => true,
                    'event'     => '',
                    'model'     => 'Inside\Content\Models\Contents\AdvancedForms',
                    'type'      => 'system',
                    'action'    => 'advanced-form-submission-edited',
                    'condition' => $v['cond'],
                    'multiple'  => false,
                    'language'  => true,
                    'profile'   => false,
                ],
                [
                    'data' => [
                        'title'       => 'notifications.advanced.form.submission.' . $v['key'] . '.title',
                        'description' => 'notifications.advanced.form.submission.' . $v['key'] . '.description',
                        'icon'        => '',
                        'text'        => 'notifications.advanced.form.submission.' . $v['key'] . '.text',
                    ],
                ]
            );

            NotificationType::firstOrCreate(
                [
                    'via'       => 'email',
                    'default'   => true,
                    'event'     => '',
                    'model'     => 'Inside\Content\Models\Contents\AdvancedForms',
                    'type'      => 'system',
                    'action'    => 'advanced-form-submission-edited',
                    'condition' => $v['cond'],
                    'multiple'  => false,
                    'language'  => true,
                    'profile'   => false,
                ],
                [
                    'data' => [
                        'title'       => 'notifications.advanced.form.submission.' . $v['key'] . '.email.title',
                        'description' => 'notifications.advanced.form.submission.' . $v['key'] . '.email.description',
                        'mail' => [
                            'text'        => 'notifications.advanced.form.submission.' . $v['key'] . '.email.text',
                            'subject'     => 'notifications.advanced.form.submission.' . $v['key'] . '.email.subject',
                            'buttonText'  => 'notifications.advanced.form.submission.buttonText',
                        ]
                    ],
                ]
            );
        }

        // C) Export terminé
        NotificationType::firstOrCreate(
            [
                'via'       => 'web',
                'default'   => true,
                'event'     => 'Inside\Form\Advanced\Events\AdvancedFormSubmissionExportedEvent',
                'model'     => 'Inside\Content\Models\Contents\AdvancedForms',
                'type'      => 'system',
                'action'    => 'advanced-form-exported',
                'condition' => null,
                'multiple'  => false,
                'language'  => true,
                'profile'   => false,
            ],
            [
                'data' => [
                    'title'       => 'notifications.advanced.form.export.title',
                    'description' => 'notifications.advanced.form.export.description',
                    'icon'        => 'ebook',
                    'text'        => 'notifications.advanced.form.export.text',
                ],
            ]
        );
    }
}
