<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\ContentCache;
use Inside\Content\Facades\Schema;
use Inside\Permission\Models\Role;
use Inside\Permission\Facades\Permission;
use Inside\Permission\Facades\PermissionSchema;

class UpdateAdvancedFormsPermissions extends Migration
{
    public function up(): void
    {
        $role = Role::where(['name' => 'authenticated'])->first();
        $this->updatePermissions($role?->id);
    }

    private function updatePermissions(?int $id): void
    {
        if (empty($id)) {
            return;
        }
        $contentTypes = collect([
            'advanced_forms' => ['read'],
            'advanced_form_submissions' => ['read', 'create', 'update', 'delete'],
        ]);

        $schemas = $contentTypes->map(fn ($actions, $type) => collect($actions)
            ->map(fn ($action) => [
                'authorizable_type' => type_to_class($type),
                'action'            => $action,
                'children'          => data_get(Schema::getModelOptions($type), 'categorizable'),
                'invert'            => false,
                'authorizable_uuid' => null,
            ]))
            ->flatten(1)
            ->toArray();

        PermissionSchema::create($schemas, $id);
        Permission::buildPermissionForRole($id);
        PermissionSchema::clean();
        ContentCache::forget([config('app.key', 'sid2'), 'all']);
    }
}
