<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable'      => true,
        'searchable'        => true,
        'global_searchable' => false,
        'aliasable'         => true,
        'permissible'       => true,
        'categorizable'     => false,
        'name'              => 'advanced_forms',
        'listing_type'      => 'content',
        'title'             => [
            'fr' => 'Formulaires avancés',
            'en' => 'Advanced forms',
            'nl' => 'Geavanceerde formulieren',
            'de' => 'Erweiterte Formulare',
            'es' => 'Formularios avanzados',
            'pt' => 'Formulários avançados',
        ],
    ],
    'fields'  => [
        // Paramètres généraux
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'show_user_info',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 6,
            'default'             => false,
            'title'               => [
                'fr' => 'Afficher les informations utilisateurs sélectionnées dans le listing des réponses',
                'en' => 'Show selected user information in the listing of responses',
                'de' => 'Ausgewählte Benutzerinformationen in der Antwortliste anzeigen',
                'nl' => 'Geselecteerde gebruikersinformatie weergeven in de lijst met antwoorden',
                'pt' => 'Mostrar as informações do utilizador selecionadas na lista de respostas',
                'es' => 'Mostrar la información del usuario seleccionada en la lista de respuestas',
            ],
            'description'         => [],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => 6,
                'group' => 'general_settings',
            ],
        ],
    ],
];
