<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable'      => true,
        'searchable'        => true,
        'global_searchable' => false,
        'aliasable'         => true,
        'permissible'       => true,
        'categorizable'     => false,
        'name'              => 'advanced_forms',
        'listing_type'      => 'content',
        'title'             => [
            'fr' => 'Formulaires avancés',
            'en' => 'Advanced forms',
            'nl' => 'Geavanceerde formulieren',
            'de' => 'Erweiterte Formulare',
            'es' => 'Formularios avanzados',
            'pt' => 'Formulários avançados',
        ],
    ],
    'fields'  => [
        // Description et image
        [
            'type'                => BridgeContentType::WYSIWYG_FIELD,
            'name'                => 'advanced_forms_description',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 0,
            'default'             => false,
            'title'               => [
                'fr' => 'Description',
                'en' => 'Description',
                'nl' => 'Beschrijving',
                'de' => 'Beschreibung',
                'es' => 'Descripción',
                'pt' => 'Descrição',
            ],
            'description'         => [
                'fr' => 'Description du formulaire',
                'en' => 'Description of the form',
                'nl' => 'Beschrijving van het formulier',
                'de' => 'Beschreibung des Formulars',
                'es' => 'Descripción del formulario',
                'pt' => 'Descrição do formulário',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::WYSIWYG_WIDGET,
                'settings' => [],
            ],
        ],
        [
            'type'                => BridgeContentType::IMAGE_FIELD,
            'name'                => 'image',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 1,
            'title'               => [
                'fr' => 'Bannière',
                'en' => 'Banner',
                'es' => 'Banner',
                'pt' => 'Banner',
                'de' => 'Banner',
                'nl' => 'Banner',
            ],
            'description'         => [
                'fr' => 'Cette image s’affiche sur toute la largeur',
                'en' => 'This image is displayed on the whole width',
                'es' => 'Esta imagen se muestra en toda la anchura',
                'pt' => 'Esta imagem é exibida em toda a largura',
                'de' => 'Dieses Bild wird auf der gesamten Breite angezeigt',
                'nl' => 'Deze afbeelding wordt over de hele breedte weergegeven',
            ],
            'widget'              => [
                'type'     => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'mimetypes'       => 'image/png,image/gif,image/jpeg',
                    'file_extensions' => 'png,gif,jpg,jpeg',
                    'max_filesize'    => 536870912,
                    'max_width'       => 300,
                    'max_height'      => 300,
                    'min_width'       => 250,
                    'min_height'      => 250,
                ],
            ],
        ],
        [
            'type'                => BridgeContentType::IMAGE_FIELD,
            'name'                => 'preview_image',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 2,
            'title' => [
                'fr' => 'Image d\'aperçu',
                'en' => 'Preview image',
                'es' => 'Imagen de vista previa',
                'pt' => 'Imagem de pré-visualização',
                'de' => 'Vorschaubild',
                'nl' => 'Voorbeeldafbeelding',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::IMAGE_WIDGET,
                'settings' => [
                    'progress_indicator' => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight' => 2,
            ],
            'settings' => [
                'uri_scheme' => 'public',
                'default_image' => [
                    'uuid' => '',
                    'alt' => '',
                    'title' => '',
                    'width' => null,
                    'height' => null,
                ],
                'target_type' => 'file',
                'display_field' => false,
                'display_default' => false,
                'cardinality' => 1,
            ],
        ],

        // Confidentialité
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'confidentiality',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 3,
            'default'             => false,
            'title'               => [
                'fr' => 'Confidentialité',
                'en' => 'Confidentiality',
                'nl' => 'Vertrouwelijkheid',
                'de' => 'Vertraulichkeit',
                'es' => 'Confidencialidad',
                'pt' => 'Confidencialidade'
            ],
            'description'         => [
                'fr' => 'Anonymiser les réponses d\'un formulaire',
                'en' => 'Anonymize the responses of a form',
                'nl' => 'Anonimiseer de antwoorden van een formulier',
                'de' => 'Anonymisieren Sie die Antworten eines Formulars',
                'es' => 'Anonimizar las respuestas de un formulario',
                'pt' => 'Anonimizar as respostas de um formulário',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => 3,
                'group' => 'confidentiality_settings',
            ],
        ],
        [
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'name'                => 'user_informations',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 4,
            'default'             => false,
            'title'               => [
                'fr' => 'Information à remonter',
                'en' => 'Information to report',
                'es' => 'Información a informar',
                'pt' => 'Informação a relatar',
                'de' => 'Zu meldende Informationen',
                'nl' => 'Te rapporteren informatie',
            ],
            'description'         => [
                'fr' => 'Les informations à remonter pour l\'utilisateur',
                'en' => 'Information to report for the user',
                'es' => 'Información a informar para el usuario',
                'pt' => 'Informação a relatar para o usuário',
                'de' => 'Zu meldende Informationen für den Benutzer',
                'nl' => 'Te rapporteren informatie voor de gebruiker',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
                'weight' => 4,
                'group' => 'confidentiality_settings',
            ],
        ],

        // Préparer les champs
        [
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'name'                => 'inputs',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 5,
            'title'               => [
                'fr' => 'Préparez les champs',
                'en' => 'Prepare fields',
                'es' => 'Preparar campos',
                'pt' => 'Preparar campos',
                'de' => 'Felder vorbereiten',
                'nl' => 'Velden voorbereiden',
            ],
            'description'         => [
                'fr' => 'Vous pouvez créer autant de champs que souhaité',
                'en' => 'You can create as many fields as you want',
                'es' => 'Puede crear tantos campos como desee',
                'pt' => 'Você pode criar quantos campos desejar',
                'de' => 'Sie können so viele Felder erstellen, wie Sie möchten',
                'nl' => 'U kunt zoveel velden maken als u wilt',
            ],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
                'weight' => 5,
            ],
        ],

        // Paramètres généraux
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'only_one_reply',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 6,
            'default'             => true,
            'title'               => [
                'fr' => 'Les utilisateurs ne peuvent répondre qu’une seule fois',
                'en' => 'Users can only answer once',
                'es' => 'Los usuarios solo pueden responder una vez',
                'pt' => 'Os usuários só podem responder uma vez',
                'de' => 'Benutzer können nur einmal antworten',
                'nl' => 'Gebruikers kunnen maar één keer antwoorden',
            ],
            'description'         => [],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => 6,
                'group' => 'general_settings',
            ],
        ],

        // Possède un statut de validation
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'has_status',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 7,
            'default'             => true,
            'title'               => [
                'fr' => 'Les demandes des utilisateurs doivent être validées par les administrateurs',
                'en' => 'User requests must be validated by administrators',
                'es' => 'Las solicitudes de los usuarios deben ser validadas por los administradores',
                'pt' => 'As solicitações dos usuários devem ser validadas pelos administradores',
                'de' => 'Benutzeranfragen müssen von Administratoren validiert werden',
                'nl' => 'Gebruikersverzoeken moeten worden gevalideerd door beheerders',
            ],
            'description'         => [],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => 7,
                'group' => 'general_settings',
            ],
        ],

        // Voir mes soumissions
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'show_my_replies',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 8,
            'default'             => false,
            'title'               => [
                'fr' => 'Les utilisateurs peuvent consulter l’historique de leurs demandes',
                'en' => 'Users can view the history of their requests',
                'es' => 'Los usuarios pueden ver el historial de sus solicitudes',
                'pt' => 'Os usuários podem ver o histórico de suas solicitações',
                'de' => 'Benutzer können den Verlauf ihrer Anfragen anzeigen',
                'nl' => 'Gebruikers kunnen de geschiedenis van hun verzoeken bekijken',
            ],
            'description'         => [],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => 8,
                'group' => 'user_settings',
            ],
        ],

        // Administrateurs
        [
            'type'                => BridgeContentType::TEXT_FIELD,
            'name'                => 'admin_roles',
            'searchable'          => false,
            'translatable'        => (count(list_languages()) > 1),
            'search_result_field' => false,
            'required'            => false,
            'weight'              => $weight++,
            'hidden'              => true,
            'default'             => '[]',
            'title'               => [
                'fr' => 'Administrateurs',
                'en' => 'Administrators',
            ],
            'description'         => [
                'fr' => 'La liste des administrateurs',
                'en' => 'Admin list',
            ],
            'widget'              => [
                'hidden' => true,
            ],
        ],
    ],
];
