<?php

namespace Inside\Form\Advanced\Services;

use Inside\Host\Bridge\BridgeContent;

class AdvancedFormService
{
    public function batchDeleteSubmissions(array $uuids): bool
    {
        $bridge = new BridgeContent();

        try {
            foreach ($uuids as $uuid) {
                $success = $bridge->contentDelete(
                    type: 'advanced_form_submissions',
                    uuid: $uuid
                );

                if ($success === false) {
                    return false;
                }
            }
        } catch (\Exception $exception) {
            return false;
        }

        return true;
    }

    public function batchUpdateSubmissionStatus(string $submissionStatus, array $uuids): bool
    {
        $bridge = new BridgeContent();

        try {
            collect($uuids)->each(
                fn ($uuid) => $bridge->contentUpdate(
                    type: 'advanced_form_submissions',
                    data: [
                        'uuid' => $uuid,
                        'submission_status' => $submissionStatus
                    ]
                )
            );
        } catch (\Exception $exception) {
            return false;
        }

        return true;
    }

    public function getSubmissionsCountFormAdvancedForm(string $uuid, string $userUuid): int
    {
        return type_to_class('advanced_form_submissions')::query()
            ->where('author_id', $userUuid)
            ->whereHas(
                'advancedForms',
                fn ($query) => $query
                ->where('uuid', $uuid)
            )
            ->get()
            ->count() ?? 0;
    }
}
