<?php

namespace Inside\Form\Advanced\Providers;

use Inside\Content\Events\ContentCreatedEvent;
use Inside\Content\Events\ContentUpdatedEvent;
use Inside\Form\Advanced\Events\AdvancedFormSubmissionExportedEvent;
use Inside\Form\Advanced\Http\Middlewares\AdvancedFormDelete;
use Inside\Form\Advanced\Http\Middlewares\AdvancedFormSubmissionUpdate;
use Inside\Form\Advanced\Http\Middlewares\PermissionsFilteredByRoleMiddleware;
use Inside\Form\Advanced\Listeners\AdvancedFormSubmissionExportListener;
use Inside\Form\Advanced\Listeners\AdvancedFormSubmissionStatusEditedListener;
use Inside\Form\Advanced\Listeners\AdvancedFormSubmissionStatusListener;
use Inside\Form\Advanced\Listeners\AdvancedFormSubmittedListener;
use Inside\Support\EventServiceProvider as BaseServiceProvider;

class AdvancedFormServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        ContentCreatedEvent::class => [
            AdvancedFormSubmittedListener::class
        ],
        ContentUpdatedEvent::class => [
            AdvancedFormSubmissionStatusEditedListener::class
        ],
        AdvancedFormSubmissionExportedEvent::class => [
            AdvancedFormSubmissionExportListener::class
        ]
    ];

    public function register(): void
    {
        $this->mergeConfigTo(__DIR__.'/../../config/advanced-form.php', 'advanced-form');
        $this->app->middleware([AdvancedFormDelete::class]);
        $this->app->middleware([PermissionsFilteredByRoleMiddleware::class]);
    }
}
