<?php

namespace Inside\Form\Advanced\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Log;
use Illuminate\Support\Facades\Storage;
use Inside\Authentication\Models\User;
use Inside\Form\Advanced\Events\AdvancedFormSubmissionExportedEvent;
use Inside\Notify\Listeners\BaseNotificationListener;
use Inside\Notify\Models\NotificationType;

class AdvancedFormSubmissionExportListener extends BaseNotificationListener implements ShouldQueue
{
    public function handle(AdvancedFormSubmissionExportedEvent $event): void
    {
        $subscriber = User::query()->find($event->userUuid);
        $filename = $event->fileName;

        if (
            ! $subscriber instanceof User ||
            empty($filename) ||
            ! Storage::disk('local')->exists($filename)
        ) {
            Log::warning("AdvancedFormSubmissionExportListener: User not found or file does not exist.", [
                'sub' => $event->userUuid,
                'file' => $event->fileName
            ]);
            return;
        }

        /** @var NotificationType[] $types */
        $types = NotificationType::where('action', 'advanced-form-exported')->get();

        foreach ($types as $type) {
            $this->when = null;
            $this->route = $subscriber;
            $this->notify(
                $type,
                $subscriber,
                null,
                [
                    'extra' => ['link' => url('api/v1/advanced-forms/donwload', [
                        pathinfo($filename, PATHINFO_EXTENSION),
                        pathinfo($filename, PATHINFO_FILENAME)
                    ])]
                ]
            );
        }
    }
}
