<?php

namespace Inside\Form\Advanced\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Inside\Authentication\Models\User;
use Inside\Form\Advanced\Services\AdvancedFormsExportService;
use Inside\Jobs\Bus\Dispatchable;

class GenerateAdvancedFormsExport implements ShouldQueue
{
    use Queueable;
    use InteractsWithQueue;
    use Dispatchable;

    public function __construct(
        public array $submissions,
        public ?string $userId = null
    ) {
    }

    public function handle(AdvancedFormsExportService $service): void
    {
        $service->setSubmissionsUuids($this->submissions)
            ->setUserUuid($this->userId)
            ->execute();

        $this->delete();
    }
}
