<?php

namespace Inside\Form\Advanced\Jobs;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;
use Inside\Authentication\Models\User;
use Inside\Form\Advanced\Services\AdvancedFormSubmissionService;
use Inside\Jobs\Bus\Dispatchable;

class DeleteAdvancedFormSubmissionsJob implements ShouldQueue
{
    use Queueable;
    use InteractsWithQueue;
    use Dispatchable;

    public function __construct(
        private string $advancedFormUuid
    ) {
    }

    public function handle(AdvancedFormSubmissionService $advancedFormSubmissionService): void
    {
        $advancedFormSubmissionService->deleteAdvancedFormSubmissionsByAdvancedFormUuid(
            $this->advancedFormUuid
        );
    }
}
