<?php

namespace Inside\Form\Advanced\Http\Middlewares;

use Closure;
use Illuminate\Http\Request;
use Inside\Form\Advanced\Actions\DeleteAdvancedForm;

/**
 * Handle automatic translation
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class AdvancedFormDelete
{
    public function handle(Request $request, Closure $next): mixed
    {
        $groupedAdvancedForms = data_get($request->all(), 'contents.advanced_forms', []);
        return match (true) {
            preg_match('/api\/v1\/content\/advanced_forms\/(-?[0-9A-F]{4,12}){5}$/i', $request->path()) &&
                $request->isMethod('DELETE') => (new DeleteAdvancedForm($request, $next))->handle(),
            preg_match('/api\/v1\/content\/delete$/i', $request->path()) &&
                $request->isMethod('DELETE') && !empty($groupedAdvancedForms) => (new DeleteAdvancedForm(
                    $request,
                    $next,
                    $groupedAdvancedForms
                ))->handle(),
            default => $next($request),
        };
    }
}
