<?php

namespace Inside\Form\Advanced\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Http\UploadedFile;
use Illuminate\Support\Facades\Storage;
use Laravel\Lumen\Routing\Controller;
use Symfony\Component\HttpFoundation\File\MimeType\MimeTypeGuesser;

class UploadFile extends Controller
{
    public function __invoke(Request $request): JsonResponse
    {
        MimeTypeGuesser::reset();

        $maxSize = UploadedFile::getMaxFilesize();

        $this->validate(
            $request,
            [
                'type'  => 'string|alpha_dash',
                'asset' => 'required|file|mimes:jpeg,png,jpg,gif,mp4,pdf,svg|max:'.$maxSize,
            ]
        );

        $disk = Storage::disk('assets');

        if (! $request->has('asset')) {
            abort(500);
        }
        /** @var UploadedFile $asset */
        $asset = $request->file('asset');
        $fileName = $asset->getClientOriginalName();

        if ($disk->exists('advanced-forms/'.$fileName)) {
            // add numeric part between file name and extension. increment file numeric index if already exists
            $fileInfo = pathinfo($fileName);
            $baseName = $fileInfo['filename'];
            $extension = isset($fileInfo['extension']) ? '.'.$fileInfo['extension'] : '';
            $counter = 1;
            while ($disk->exists('advanced-forms/'.$baseName.'-'.$counter.$extension)) {
                $counter++;
            }
            $fileName = $baseName.'-'.$counter.$extension;
        }

        $file = $disk->putFileAs('advanced-forms', $asset, $fileName);

        return response()->json([
            'url' => $disk->url($file),
            'name' => $asset->getClientOriginalName(),
            'size' => $asset->getSize(),
            'type' => $asset->getMimeType(),
        ]);
    }
}
