<?php

namespace Inside\Form\Advanced\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Inside\Form\Advanced\Http\Requests\ExportSubmissionsRequest;
use Inside\Form\Advanced\Jobs\GenerateAdvancedFormsExport;
use Inside\Form\Advanced\Services\AdvancedFormsExportService;
use Laravel\Lumen\Routing\Controller;

class ExportSubmissions extends Controller
{
    public function __invoke(ExportSubmissionsRequest $request): JsonResponse
    {
        $uuids = $request->get('uuids', []);
        $response = ['success' => true];

        /*GenerateAdvancedFormsExport::dispatch(
            $uuids,
            optional($request->user())->uuid
        );*/

        (new GenerateAdvancedFormsExport(
            $uuids,
            optional($request->user())->uuid
        ))->handle(app(AdvancedFormsExportService::class));

        return response()->json($response, 200);
    }
}
