<?php

namespace Inside\Form\Advanced\Actions;

use Closure;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Inside\Form\Advanced\Jobs\DeleteAdvancedFormSubmissionsJob;
use Inside\Form\Advanced\Services\AdvancedFormSubmissionService;

final class DeleteAdvancedForm
{
    public function __construct(
        protected Request $request,
        private Closure $next,
        private array $uuids = []
    ) {
    }

    public function handle(): JsonResponse
    {
        $response = ($this->next)($this->request);
        $data = $response->getData(true);

        if (
            !empty($data['uuid'])
        ) {
            (new DeleteAdvancedFormSubmissionsJob($data['uuid']))->handle(
                app()->make(AdvancedFormSubmissionService::class)
            );
        }

        foreach ($this->uuids as $uuid) {
            if (in_array($uuid, $data)) {
                (new DeleteAdvancedFormSubmissionsJob($uuid))->handle(
                    app()->make(AdvancedFormSubmissionService::class)
                );
            }
        }

        return $response;
    }
}
