<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Illuminate\Support\Facades\Artisan;

class UpdateAdvancedFormsOptions extends Migration
{
    public function up(): void
    {
        $bridgeContentType = new BridgeContentType();
        $bridgeContentType->updateFieldOptions(
            type: 'advanced_forms',
            fieldName: 'has_status',
            options: [
                'name' => 'has_status',
                'search_result_field' => true,
                'searchable_filter' => true,
                'searchable' => true
            ]
        );
        Artisan::call('inside:revision:init');
    }
}
