<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;

class UpdateAdvancedFormsDeleteStrategy extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        $this->bootUp(__FILE__);

        $bridge = new BridgeContentType();

        $bridge->contentTypeUpdate('advanced_forms', ['deletion_strategy' => 'none']);
        $bridge->contentTypeUpdate('advanced_form_submissions', ['deletion_strategy' => 'none']);

        $this->finishUp();
    }
}
