<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable'      => true,
        'searchable'        => true,
        'global_searchable' => false,
        'aliasable'         => true,
        'permissible'       => true,
        'categorizable'     => false,
        'name'              => 'advanced_form_submissions',
        'listing_type'      => 'hidden',
        'title'             => [
            'fr' => 'Soumissions de formulaire avancé',
            'en' => 'Advanced Form Submissions',
            'es' => 'Envíos de formulario avanzado',
            'pt' => 'Envios de formulário avançado',
            'de' => 'Erweiterte Formularübermittlungen',
            'nl' => 'Geavanceerde formulierinzendingen',
        ],
    ],
    'fields'  => [
        [
            'name' => 'advanced_forms',
            'searchable' => false,
            'translatable' => true,
            'search_result_field' => false,
            'searchable_filter' => false,
            'required' => false,
            'weight' => 0,
            'title' => [
                'fr' => 'Formulaires avancés',
                'en' => 'Advanced Forms',
                'es' => 'Formularios avanzados',
                'pt' => 'Formulários avançados',
                'de' => 'Erweiterte Formulare',
                'nl' => 'Geavanceerde formulieren',
            ],
            'description' => [],
            'widget' => [
                'type' => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
                'weight' => 0,
            ],
            'type' => BridgeContentType::REFERENCE_FIELD,
            'settings' => [
                'target_type' => ['advanced_forms'],
                'cardinality' => 1,
            ],
            'selectable_all' => false,
        ],
        [
            'type'                => BridgeContentType::LIST_STRING_FIELD,
            'name'                => 'submission_status',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'default'             => 'pending',
            'weight'              => 0,
            'title'               => [
                'fr' => 'Statut de la soumission',
                'en' => 'Submission Status',
                'es' => 'Estado de la presentación',
                'pt' => 'Status da submissão',
                'de' => 'Einreichungsstatus',
                'nl' => 'Indieningsstatus',
            ],
            'description'         => [],
            'settings'            => [
                'allowed_values' => [
                    'pending'   => [
                        'fr' => 'En cours',
                        'en' => 'Pending',
                        'es' => 'Pendiente',
                        'pt' => 'Pendente',
                        'de' => 'Ausstehend',
                        'nl' => 'In behandeling',
                    ],
                    'accepted' => [
                        'fr' => 'Accepté',
                        'en' => 'Accepted',
                        'es' => 'Aceptado',
                        'pt' => 'Aceito',
                        'de' => 'Akzeptiert',
                        'nl' => 'Geaccepteerd',
                    ],
                    'rejected' => [
                        'fr' => 'Rejeté',
                        'en' => 'Rejected',
                        'es' => 'Rechazado',
                        'pt' => 'Rejeitado',
                        'de' => 'Abgelehnt',
                        'nl' => 'Afgewezen',
                    ],
                ],
            ],
            'widget'              => [
                'type'     => BridgeContentType::SELECT_WIDGET,
                'settings' => [],
            ],
        ],
        [
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'name'                => 'output',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 2,
            'default'             => false,
            'title'               => [
                'fr' => 'Réponses',
                'en' => 'Answers',
                'es' => 'Respuestas',
                'pt' => 'Respostas',
                'de' => 'Antworten',
                'nl' => 'Antwoorden',
            ],
            'description'         => [],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
                'weight' => 2,
            ],
        ],
        [
            'type'                => BridgeContentType::TEXTAREA_FIELD,
            'name'                => 'feed_back',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 3,
            'default'             => false,
            'title'               => [
                'fr' => 'Commentaires',
                'en' => 'Comments',
                'es' => 'Comentarios',
                'pt' => 'Comentários',
                'de' => 'Kommentare',
                'nl' => 'Opmerkingen',
            ],
            'description'         => [],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [],
                'weight' => 3,
            ],
        ],
        [
            'type'                => BridgeContentType::BOOLEAN_FIELD,
            'name'                => 'notify',
            'searchable'          => false,
            'translatable'        => true,
            'search_result_field' => false,
            'required'            => false,
            'weight'              => 4,
            'default'             => true,
            'title'               => [
                'fr' => 'Envoyer un mail au demandeur',
                'en' => 'Send an email to the requester',
                'es' => 'Enviar un correo electrónico al solicitante',
                'pt' => 'Enviar um e-mail para o solicitante',
                'de' => 'E-Mail an den Anforderer senden',
                'nl' => 'Stuur een e-mail naar de aanvrager',
            ],
            'description'         => [],
            'settings'            => [],
            'widget'              => [
                'type'     => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                'settings' => [],
                'weight' => 4
            ],
        ],
    ],
];
