import SpacePagesPage from '../pages/spaces/SpacesPagesPage'
import SpacePage from '../pages/spaces/SpacePage'
import WidgetSpacesPage from '../pages/widget/WidgetSpacesPage'
import WidgetPage from '../pages/widget/WidgetPage'

import HighlightPage from '../pages/highlights/HighlightPage'

import HermionePage from '../pages/hermione/HermionePage'
import HermioneSpacePage from '../pages/hermione/HermioneSpacePage'

import AdminAdvancedSettingsHomePage from '../pages/advanced-settings/AdminAdvancedSettingsHomePage'
import AdminAdvancedSettingsIdentityPage from '../pages/advanced-settings/AdminAdvancedSettingsIdentityPage'
import { fetchSettings } from '@inside-administration/fetch'

import { withFetch } from 'inside-collection/hocs'

import {
  fetchHermioneSpace,
  fetchHermionePage,
  fetchSpacesPage,
  fetchSpace,
  fetchWidgetSpacesPage,
  fetchWidgetPage,
  fetchHighlight
} from '../fetch'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    component: () => import('../pages/news/NewsListingPage')
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'ArchivedNewsListingPage',
    path: '/actus-archives',
    component: () => import('../pages/news/ArchivedNewsListingPage')
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false },
    props: {
      bannerData: {
        useEmptyBanner: true
      }
    }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    component: () => import('../pages/users/DirectoryPage'),
    meta: { disabled: false }
  },
  {
    name: 'JobsListingPage',
    component: () => import('../pages/jobs/JobsListingPage'),
    path: '/j-evolue'
  },
  {
    name: 'JobsJsonPage',
    component: () => import('../pages/jobs/JobsJsonPage'),
    path: '/jobs-json'
  },
  {
    name: 'JobsListPage',
    component: () => import('../pages/jobs/JobsListPage'),
    path: '/jobs-liste'
  },
  {
    name: 'SpacePage',
    path: '/espace/:slug',
    component: withFetch(SpacePage, { size: 'xxl', watch: true })(fetchSpace)
  },
  {
    name: 'SpacesPagesPage',
    path: '/pages-espace/:slug',
    component: withFetch(SpacePagesPage, { size: 'xxl' })(fetchSpacesPage)
  },
  {
    name: 'WidgetSpacesPage',
    path: '/espaces-widget/:slug',
    component: withFetch(WidgetPage, { size: 'xxl' })(fetchWidgetPage)
  },
  {
    name: 'WidgetPage',
    path: '/espaces-widget/:slug/pages',
    component: withFetch(WidgetSpacesPage, { size: 'xxl' })(
      fetchWidgetSpacesPage
    )
  },
  {
    name: 'HighlightsListingPage',
    path: '/temps-forts',
    component: () => import('../pages/highlights/HighlightsListingPage')
  },
  {
    name: 'HighlightPage',
    path: '/temps-forts/:slug',
    component: withFetch(HighlightPage, { size: 'xxl' })(fetchHighlight)
  },
  {
    name: 'HighlightNewsPage',
    path: '/temps-forts/:highlight/actus/:slug',
    component: () => import('../pages/highlights/HighlightNewsPage')
  },
  {
    name: 'HermioneSpacePage',
    path: '/hermione/:slug',
    component: withFetch(HermioneSpacePage, { size: 'xxl', watch: true })(
      fetchHermioneSpace
    )
  },
  {
    name: 'HermionePage',
    path: '/hermione',
    component: withFetch(HermionePage, { size: 'xxl', watch: true })(
      fetchHermionePage
    )
  },
  {
    name: 'HermioneNewsPage',
    path: '/hermione/:space/:slug',
    component: () => import('../pages/hermione/HermioneNewsPage')
  },
  {
    name: 'SimplePage',
    meta: {
      disabled: false
    },
    props: {
      bannerData: {
        useEmptyBanner: true
      }
    }
  },
  {
    name: 'TeamsListingPage',
    props: {
      bannerData: {
        useEmptyBanner: true
      }
    }
  },
  {
    name: 'AdminAdvancedSettingsHomePage',
    component: withFetch(AdminAdvancedSettingsHomePage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  },
  {
    name: 'AdminAdvancedSettingsIdentityPage',
    component: withFetch(AdminAdvancedSettingsIdentityPage, { size: 'xxl' })(
      fetchSettings
    ),
    meta: { admin: true, display: true }
  }
]
