import { onMounted } from 'vue'
import { getAppInstance } from '@inside-core/helpers/getAppInstance'

import JobsModal from '../components/jobs/JobsModal'
import HighlightNewsModal from '../components/modals/HighlightNewsModal'
import FlashInfoModal from '../components/modals/FlashInfoModal'
import NewComersModal from '../components/modals/NewComersModal'

export function useGlobalComponents() {
  const app = getAppInstance()

  onMounted(() => {
    app.component('jobs-modal', JobsModal)
    app.component('highlight-news-modal', HighlightNewsModal)
    app.component('flash-info-modal', FlashInfoModal)
    app.component('new-comers-modal', NewComersModal)
  })
}
