import { http } from '@inside-library/helpers/Http'

const hermioneReferenceDeletion = async ({ uuid, contentType }) => {
  try {
    const { data } = await http.get(`content/${contentType}`, {
      fields: [{ hermione_spaces: ['slug'] }],
      filters: { 'uuid:eq': uuid }
    })

    return {
      name: 'HermioneSpacePage',
      params: { slug: data[0].hermione_spaces.data[0].slug[0] }
    }
  } catch {
    return { name: 'HermionePage' }
  }
}

export default {
  contracts: {
    add: () => ({ name: 'JobsListingPage' }),
    delete: () => ({ name: 'JobsListingPage' })
  },
  jobs: {
    add: () => ({ name: 'JobsListingPage' }),
    delete: () => ({ name: 'JobsListingPage' })
  },
  newComer: {
    add: () => ({ name: 'NewcomersListingPage' }),
    delete: () => ({ name: 'NewcomersListingPage' }),
    globalSearch: ({ vm, data }) => ({
      action: () =>
        vm.triggerModal(
          'new-comers',
          'fetch',
          { item: data, content: data.content_type },
          { layout: 'right', transition: 'fadeInLeft' }
        )
    })
  },
  newComerCategories: {
    extends: 'newComer'
  },
  spaces: {
    add: ({ data }) => ({
      name: 'SpacePage',
      params: { slug: data.slug[0] }
    })
  },
  spacesPages: {
    add: ({ data }) => ({
      name: 'SpacesPagesPage',
      params: { slug: data.slug[0] }
    }),
    delete: async ({ data }) => {
      try {
        const { data: page } = await http.get(
          'content/spaces_pages_categories',
          {
            filters: {
              'uuid:eq': data.uuid
            },
            fields: [
              'uuid',
              'title',
              {
                tabs: ['uuid', 'title', { spaces: ['uuid', 'title', 'slug'] }]
              }
            ]
          }
        )

        return {
          name: 'SpacePage',
          params: {
            slug: page[0]?.spaces_pages_categories.spaces?.slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  hermione: {
    add: () => ({ name: 'HermionePage' })
  },
  hermioneAxes: {
    add: () => ({ name: 'HermionePage' }),
    delete: () => ({ name: 'HermionePage' })
  },
  hermioneSpaces: {
    add: ({ data }) => ({
      name: 'HermioneSpacePage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ name: 'HermionePage' })
  },
  hermioneNewsCategories: {
    add: () => ({ name: 'HermionePage' }),
    delete: () => ({ name: 'HermionePage' })
  },
  hermioneDocuments: {
    fields: [{ hermione_spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'HermioneSpacePage',
      params: { slug: data.hermione_spaces.data[0].slug[0] }
    }),
    delete: hermioneReferenceDeletion
  },
  hermioneNews: {
    fields: [{ hermione_spaces: ['slug'] }],
    add: ({ data }) => ({
      name: 'HermioneNewsPage',
      params: {
        space: data.hermione_spaces.data[0].slug[0],
        slug: data.slug[0]
      }
    }),
    delete: hermioneReferenceDeletion
  },
  highlights: {
    add: ({ data }) => ({
      name: 'HighlightPage',
      params: {
        slug: data.slug[0]
      }
    }),
    delete: () => ({ name: 'HighlightsListingPage' })
  },
  highlightsStatus: {
    add: ({ data }) => ({
      name: 'HighlightsListingPage',
      query: {
        highlights_status: data.uuid
      }
    }),
    delete: () => ({ name: 'HighlightsListingPage' })
  },
  highlightsTypes: {
    add: ({ data }) => ({
      name: 'HighlightsListingPage',
      query: {
        highlights_types: data.uuid
      }
    }),
    delete: () => ({ name: 'HighlightsListingPage' })
  },
  highlightsDocuments: {
    add: async ({ data }) => {
      try {
        const { data: highlight } = await http.get(
          'content/highlights_documents',
          {
            fields: [{ highlights: ['uuid', 'title', 'slug'] }],
            filters: {
              'uuid:eq': data.uuid
            }
          }
        )

        return {
          name: 'HighlightPage',
          params: {
            slug: highlight[0].highlights.slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data: highlight } = await http.get(
          'content/highlights_documents',
          {
            fields: [{ highlights: ['uuid', 'title', 'slug'] }],
            filters: {
              'uuid:eq': uuid
            }
          }
        )

        return {
          name: 'HighlightPage',
          params: {
            slug: highlight[0].highlights.slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    globalSearch: ({ data }) => ({
      action: () => {
        const url = data.file ? data.file.path : data.link.url
        window.open(url, '_blank')
      }
    })
  },
  highlightsNews: {
    add: async ({ data }) => {
      try {
        const { data: news } = await http.get('content/highlights_news', {
          fields: [{ highlights: ['uuid', 'title', 'slug'] }],
          filters: {
            'uuid:eq': data.uuid
          }
        })

        return {
          name: 'HighlightNewsPage',
          params: {
            highlight: news[0].highlights.slug[0],
            slug: data.slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: async ({ uuid }) => {
      try {
        const { data: news } = await http.get('content/highlights_news', {
          fields: [{ highlights: ['uuid', 'title', 'slug'] }],
          filters: {
            'uuid:eq': uuid
          }
        })

        return {
          name: 'HighlightPage',
          params: {
            slug: news[0].highlights.slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  spacesPagesCategories: {
    add: async ({ data }) => {
      try {
        const { data: cat } = await http.get(
          'content/spaces_pages_categories',
          {
            filters: {
              'uuid:eq': data.uuid
            },
            fields: [{ spaces: ['uuid', 'title', 'slug'] }]
          }
        )

        return {
          name: 'SpacePage',
          params: {
            slug: cat[0]?.spaces?.slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    },
    delete: async ({ data }) => {
      try {
        const { data: cat } = await http.get(
          'content/spaces_pages_categories',
          {
            filters: {
              'uuid:eq': data.uuid
            },
            fields: [{ spaces: ['uuid', 'title', 'slug'] }]
          }
        )

        return {
          name: 'SpacePage',
          params: {
            slug: cat[0]?.spaces?.slug[0]
          }
        }
      } catch (err) {
        throw new Error(err)
      }
    }
  },
  widgetSpaces: {
    add: ({ data }) => ({
      name: 'WidgetSpacesPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({
      name: 'HomePage'
    })
  },
  tabs: {
    add: async ({ data }) => {
      const { data: tabs } = await http.get('content/tabs', {
        fields: [
          'uuid',
          'slug',
          {
            widget_spaces: {
              fields: ['uuid', 'title', 'slug']
            }
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      return {
        name: 'WidgetPage',
        params: {
          slug: tabs[0].widget_spaces.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: tabs } = await http.get('content/tabs', {
        fields: [
          'uuid',
          {
            widget_spaces: {
              fields: ['uuid', 'title', 'slug']
            }
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': uuid
        }
      })

      return {
        name: 'WidgetPage',
        params: {
          slug: tabs[0].widget_spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: tabs } = await http.get('content/tabs', {
        fields: ['uuid', { widget_spaces: ['uuid', 'title', 'slug'] }],
        filters: { 'status:eq': 1, 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'WidgetPage',
          params: {
            slug: tabs[0].widget_spaces.slug[0]
          }
        }
      }
    }
  },
  tabsPages: {
    add: async ({ data }) => {
      const { data: tabPages } = await http.get('content/tabs_pages', {
        fields: [
          'uuid',
          'slug',
          {
            tabs: [
              'uuid',
              'title',
              {
                widget_spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      return {
        name: 'WidgetPage',
        params: {
          slug: tabPages[0].tabs.widget_spaces.slug[0]
        },
        query: { page: data.uuid }
      }
    },
    delete: async ({ uuid }) => {
      const { data: tabPages } = await http.get('content/tabs_pages', {
        fields: [
          'uuid',
          'title',
          {
            tabs: [
              'uuid',
              'title',
              {
                widget_spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': uuid
        }
      })

      return {
        name: 'WidgetPage',
        params: {
          slug: tabPages[0].tabs.widget_spaces.slug[0]
        }
      }
    },
    globalSearch: async ({ data }) => {
      const { data: tabPage } = await http.get('content/tabs_pages', {
        fields: [
          'uuid',
          'title',
          {
            tabs: [
              'uuid',
              'title',
              {
                widget_spaces: {
                  fields: ['uuid', 'title', 'slug']
                }
              }
            ]
          }
        ],
        filters: { 'uuid:eq': data.uuid }
      })

      return {
        route: {
          name: 'WidgetPage',
          params: {
            slug: tabPage[0].tabs.widget_spaces.slug[0]
          },
          query: { page: data.uuid }
        }
      }
    }
  }
}
