export default {
  globals: {
    notificationRedirectionsContentTypes: ['news', 'spaces_pages'],
    notificationRedirections: {
      news: async ({ data }) => ({
        name: 'NewsPage',
        params: {
          slug: data.slug[0]
        }
      }),
      spacesPages: ({ data }) => ({
        name: 'SpacesPagesPage',
        params: { slug: data.slug[0] }
      })
    }
  },
  'inside-administration': {
    disabledAdvancedSettingsFields: ['ged_enable_likes']
  },
  'inside-comments': {
    mentionsEnabled: true
  },
  'inside-customs': {
    templates: {
      fullContent: {
        highlightsNews: {
          mainComponent: () => import('@inside-news/components/lib/Full')
        },
        hermioneNews: {
          mainComponent: () => import('@inside-news/components/lib/Full'),
          mainFields: () => [
            'content',
            'image',
            {
              hermione_news_categories: {
                fields: ['uuid', 'title', 'content_type', 'color'],
                filters: { 'status:eq': 1 }
              }
            }
          ],
          relatedComponent: () => import('./components/hermione/HermioneMinimalNews')
        }
      }
    }
  },
  'inside-layouts': {
    darkModeMenuEnabledFor: ['*']
  },
  'inside-newcomers': {
    rootRoute: {
      fr: '/bienvenue-a-bord'
    }
  },
  'inside-news': {
    bookmarkEnabled: false,
    showBookmarks: false,
    rootRoute: {
      fr: 'actus'
    }
  },
  'inside-paragraphs': {
    fetchedContents: {
      availabledContentTypes: ['news', 'users', 'events', 'quiz']
    }
  },
  'inside-teams': {
    rootRoute: {
      fr: 'communautes'
    }
  },
  'inside-users': {
    login: {
      useGradient: false,
      useImage: true
    },
    shortcuts: {
      max: 6
    },
    profil: {
      enabledProfilTabs: [
        { name: 'profil', restrictions: [], icon: 'user' },
        { name: 'shortcuts', restrictions: [], icon: 'news' },
        { name: 'notifications', restrictions: [], icon: 'settings' }
      ]
    }
  }
}
