import { http } from '@inside-library/helpers/Http'

import { newsFields } from '../constants'

export const fetchHighlight = async ({ $route }) => {
  try {
    const { data } = await http.get('content/highlights', {
      fields: [
        'uuid',
        'title',
        'content_type',
        'admin',
        'slug',
        'banner',
        'image',
        'date',
        'end_date',
        'introduction',
        'presentation',
        { highlights_status: ['uuid', 'title', 'color'] },
        { highlights_types: ['uuid', 'title'] },
        { comments: ['count'] }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchSpacesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces_pages', {
      fields: ['uuid', 'title', 'content_type', 'admin', 'content', 'image'],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchSpace = async ({ $route }) => {
  try {
    const { data } = await http.get('content/spaces', {
      fields: [
        'uuid',
        'title',
        'content_type',
        'admin',
        'banner',
        'inspirite_banner',
        'inspirite_link',
        'last_inspirite'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchWidgetPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/widget_spaces', {
      fields: [
        'uuid',
        'title',
        'banner',
        'published_at',
        'introduction',
        'admin',
        'content_type',
        'slug',
        {
          users: {
            fields: [
              'uuid',
              'firstname',
              'lastname',
              'image',
              'function',
              'phone'
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          news: {
            fields: [
              'uuid',
              'title',
              'slug',
              'introduction',
              'published_at',
              'image',
              'chapo',
              'content_type',
              { news_categories: ['uuid', 'title'] },
              { reactions: ['count', { users: ['uuid'] }] },
              { comments: ['count'] }
            ],
            filters: {
              'status:eq': 1,
              limit: 1
            }
          }
        },
        {
          news_categories: {
            fields: [
              'uuid',
              'title',
              {
                news: {
                  fields: [
                    'uuid',
                    'title',
                    'slug',
                    'introduction',
                    'published_at',
                    'image',
                    'chapo',
                    'content_type',
                    { news_categories: ['uuid', 'title'] },
                    { reactions: ['count', { users: ['uuid'] }] },
                    { comments: ['count'] }
                  ],
                  filters: {
                    reverse: true,
                    'status:eq': 1,
                    sort: 'published_at:desc'
                  }
                }
              }
            ],
            filters: {
              'status:eq': 1
            }
          }
        },
        {
          tabs: { fields: ['count'], filters: { reverse: true } }
        }
      ],
      filters: {
        'status:eq': 1,
        'slug:eq': $route.params.slug
      }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchWidgetSpacesPage = async ({ $route }) => {
  try {
    const { data } = await http.get('content/widget_spaces', {
      fields: [
        'uuid',
        'title',
        'content_type',
        'admin',
        'banner',
        'introduction'
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchHermionePage = async () => {
  try {
    const { data } = await http.get('content/hermione', {
      fields: [
        'uuid',
        'content',
        {
          hermione_axes: {
            fields: [
              'uuid',
              'title',
              'axes_introduction',
              'color',
              'admin',
              'content_type',
              {
                hermione_spaces: {
                  fields: ['uuid', 'title', 'slug', 'hermione_image'],
                  filters: {
                    'status:eq': 1,
                    sort: 'weight:asc'
                  }
                }
              }
            ],
            filters: { 'status:eq': 1, sort: 'weight:asc', reverse: true }
          }
        }
      ],
      filters: { sort: 'published_at:desc', limit: 1 }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}

export const fetchHermioneSpace = async ({ $route }) => {
  try {
    const userFields = [
      'uuid',
      'firstname',
      'lastname',
      'image',
      'phone',
      'function'
    ]
    const hermioneNewsFields = [
      ...newsFields,
      {
        hermione_news_categories: {
          fields: ['uuid', 'title'],
          filters: { 'status:eq': 1 }
        }
      }
    ]

    const { data } = await http.get('content/hermione_spaces', {
      fields: [
        'uuid',
        'title',
        'hermione_banner',
        'hermione_video',
        'hermione_image',
        'hermione_description',
        'content_type',
        'admin',
        'slug',
        'color',
        { comments: ['count'] },
        { sponsors: userFields },
        { managers: userFields },
        { project_managers: userFields },
        { si_referents: userFields },
        {
          hermione_spaces: {
            fields: ['title', 'slug', 'color', 'hermione_image'],
            filters: { 'status:eq': 1, sort: 'weight:asc' }
          }
        },
        {
          'hermione_spaces.hermione_spaces': {
            fields: ['title', 'slug'],
            filters: {
              reverse: true,
              alias: 'parent'
            }
          }
        },
        {
          hermione_documents: {
            fields: [
              'uuid',
              'title',
              'file',
              'content_type',
              'admin',
              'has_section'
            ],
            filters: { 'status:eq': 1, sort: 'updated_at:desc', reverse: true }
          }
        },
        {
          hermione_news: {
            fields: hermioneNewsFields,
            filters: {
              'status:eq': 1,
              limit: 5,
              sort: 'published_at:desc',
              reverse: true
            }
          }
        }
      ],
      filters: { 'slug:eq': $route.params.slug }
    })

    return data[0]
  } catch (err) {
    throw new Error(err)
  }
}
