<?php

namespace Inside\INMU\Providers;

use Illuminate\Support\Facades\Event;
use Inside\Events\InsideBooted;
use Inside\INMU\Listeners\AddWidgetToFrontend;
use Inside\Support\EventServiceProvider as BaseServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * INMU Service provider.
 *
 * @category Class
 * @package  Inside\INMU\Providers\ServiceProvider
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class ServiceProvider extends BaseServiceProvider
{
    protected array $listen = [
        InsideBooted::class => [
            AddWidgetToFrontend::class,
        ],
    ];

    public function register(): void
    {
        try {
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
            $this->mergeConfigTo(__DIR__.'/../../config/azuread.php', 'azuread');
            $this->mergeConfigTo(__DIR__.'/../../config/notify.php', 'notify');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }
    }
}
