<?php

namespace Inside\INMU\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\News;
use Inside\Reaction\Facades\Reactions;
use Laravel\Lumen\Routing\Controller;

class ReactionController extends Controller
{
    public function Reaction(Request $request): JsonResponse
    {
        /** @var User $user */
        $user = Auth::user();

        $reactions = DB::table('inside_reactions')
            ->where('type', 'flashinfo')
            ->where('user_uuid', $user->uuid)
            ->orderBy('created_at', 'DESC')->get();

        $data_uuid = $request->get('uuid');

        $data = News::find($data_uuid);

        if ($reactions->count()) {
            foreach ($reactions as $reaction) {
                Reactions::delete('flashinfo', $reaction->reactionable_uuid, $reaction->user_uuid, $reaction->langcode);
            }
        }

        return response()->json(Reactions::create([
            'user_uuid' => $user->uuid,
            'reactionable_uuid' => $data_uuid,
            'reactionable_type' => "Inside\Content\Models\Contents\News",
            'type' => 'flashinfo',
            'langcode' => $data->langcode,
        ]));
    }
}
