<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddCommentsToHermioneNews extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateField(
            'hermione_news',
            'comments',
            [
                'name' => 'comments',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'search_filter' => false,
                'required' => false,
                'weight' => 11,
                'title' => [
                    'fr' => 'Commentaires',
                    'en' => 'Comments',
                ],
                'widget' => [
                    'hidden' => true,
                ],
                'type' => BridgeContentType::COMMENT_FIELD,
                'settings' => [
                    'comment_type' => 'comments',
                    'cardinality' => 1,
                ],
        ]
        );
    }
}
