<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldEndDate extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateField(
            'news',
            'end_date',
            [
                'name' => 'end_date',
                'searchable' => false,
                'translatable' => false,
                'default' => null,
                'search_result_field' => false,
                'required' => false,
                'weight' => 3,
                'title' => [
                    'fr' => 'Date de fin'
                ],
                'description' => [],
                'widget' => [
                    'type' => BridgeContentType::TIMESTAMP_WIDGET,
                    'settings' => [],
                    'weight' => 3,
                ],
                'type' => BridgeContentType::TIMESTAMP_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
        );
    }

    public function down(): void
    {
    }
}
