<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddIsFeaturedFieldToForms extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeCreateField(
            'forms',
            'is_featured',
            [
                'name' => 'is_featured',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 6,
                'title' => [
                    'fr' => 'Est mis en avant ?'
                ],
                'description' => [
                    'fr' => ''
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'group' => 'group_advanced_options',
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
            ],
            6
        );
    }

    public function down(): void
    {
    }
}
