<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddFieldsLinkToHighlightsDocuments extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $field = [
            'name' => 'link',
            'searchable' => false,
            'translatable' => false,
            'search_result_field' => false,
            'required' => false,
            'default' => false,
            'weight' => 1,
            'type' => BridgeContentType::LINK_FIELD,
            'title' => [
                'fr' => 'Lien',
            ],
            'widget' => [
                'type' => BridgeContentType::STRING_WIDGET,
                'settings' => [],
                'weight' => 1,
            ],
            'settings' => [
                'cardinality' => 1,
            ],
        ];

        $bridge->contentTypeCreateOrUpdateField('highlights_documents', 'link', $field);
        $bridge->updateFieldOptions('highlights_documents', 'file', ['required' => false]);
    }

    public function down(): void
    {
    }
}
