<?php

namespace Inside\INMU\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Inside\Authentication\Models\User;
use Inside\Content\Models\Contents\News;
use Laravel\Lumen\Routing\Controller;

class PopinController extends Controller
{
    public function popin(): JsonResponse
    {
        $flashInfo = News::query()->where('is_flash', 1)->where('status', 1)->orderBy('created_at', 'DESC')->first();
        $user = Auth::user();

        if (empty($flashInfo) || !$user instanceof User) {
            return response()->json([
                'popin' => false,
            ]);
        }

        $reaction = DB::table('inside_reactions')
            ->where('type', 'flashinfo')
            ->where('user_uuid', $user->uuid)
            ->where('reactionable_uuid', $flashInfo->uuid)
            ->where('created_at', 'LIKE', date('Y-m-d', time()).' %')
            ->orderBy('created_at', 'DESC')->get();

        $count = $reaction->count();

        return response()->json([
            'popin' => $count === 0,
            'reaction_date' => $count === 0 ? null : $reaction->pluck('created_at')->first(),
        ]);
    }
}
