<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\Groups;
use Inside\Notify\Facades\NotificationType as NotificationTypeHelper;
use Inside\Notify\Models\NotificationType;

class SubscribeUsersToPublicGroupsNotifications extends Migration
{
    public function up(): void
    {
        $publicGroups = Groups::where('visibility', 'public')->get();
        foreach ($publicGroups as $publicGroup) {
            $notificationTypes = NotificationType::where('condition', 'groups:'.$publicGroup->uuid)
                ->where('action', 'custom')
                ->get();

            $notificationTypes->each(function ($notificationType) use ($publicGroup) {
                NotificationTypeHelper::subscribeRoles(
                    $notificationType,
                    'group-'.$publicGroup->uuid.'-member',
                    true
                );
            });
        }
    }
}
