<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\NewComer;
use Inside\Content\Models\Contents\NewComerCategories;
use Inside\Host\Bridge\BridgeContent;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Host\Migrations\CreateContentTypes;
use Inside\Content\Facades\Schema;

class ReplaceNewComersWithMovements extends Migration
{
    use CreateContentTypes;

    public function up(): void
    {
        if (!Schema::hasModel('movements') || !Schema::hasModel('new_comer')) {
            return;
        }

        $bridgeContentType = new BridgeContentType();
        $bridgeContent = new BridgeContent();

        NewComer::each(function (NewComer $comer) use ($bridgeContent) {
            $bridgeContent->contentDelete('new_comer', $comer->uuid);
        });

        NewComerCategories::each(function (NewComerCategories $comerCategory) use ($bridgeContent) {
            $bridgeContent->contentDelete('new_comer_categories', $comerCategory->uuid);
        });

        $bridgeContentType->contentTypeDelete('new_comer');
        $bridgeContentType->contentTypeDelete('new_comer_categories');
    }
}
