<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class UpdateHermioneSpacesType extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeUpdateField('hermione_spaces', 'hermione_video', [
            'name' => 'hermione_video',
            'searchable' => false,
            'translatable' => false,
            'default' => false,
            'search_result_field' => false,
            'required' => false,
            'weight' => -2,
            'title' => [
                'fr' => 'Video',
            ],
            'description' => [
                'fr' => 'Lien de la vidéo',
            ],
            'widget' => [
                'type' => BridgeContentType::LONGTEXT_WIDGET,
                'settings' => [
                    'rows' => 5,
                    'placeholder' => '',
                ],
                'weight' => -2,
            ],
            'type' => BridgeContentType::TEXTAREA_FIELD,
            'settings' => [
                'case_sensitive' => false,
                'cardinality' => 1,
            ],
        ]);

        $bridge->contentTypeDeleteField('node', 'hermione_spaces', 'hermione_spaces');

        $bridge->contentTypeCreateField(
            'hermione_spaces',
            'hermione_spaces',
            [
                'name' => 'hermione_spaces',
                'searchable' => false,
                'translatable' => false,
                'default' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => -3,
                'title' => [
                    'fr' => 'Programme associé',
                ],
                'description' => [
                    'fr' => '',
                ],
                'widget' => [
                    'type' => BridgeContentType::SELECT_WIDGET,
                    'settings' => [],
                    'weight' => -3,
                ],
                'type' => BridgeContentType::REFERENCE_FIELD,
                'settings' => [
                    'target_type' => ['hermione_spaces'],
                    'cardinality' => 1,
                ],
                'selectable_all' => false,
            ]
        );
    }

    public function down(): void
    {
    }
}
