<?php

use Carbon\Carbon;
use Illuminate\Database\Migrations\Migration;
use Inside\Content\Models\Contents\News;
use Inside\Host\Bridge\BridgeContent;

class PublishUnpublishedNews extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContent();
        $unpublishedNews = News::query()->where('status', 0)->get();
        $endDate = Carbon::now()->subWeek()->toDateTimeString();

        foreach ($unpublishedNews as $news) {
            $bridge->contentUpdate('news', [
                'uuid' => $news->uuid,
                'end_date' => $endDate,
                'status' => 1
            ]);
        }
    }

    public function down(): void
    {
    }
}
