<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddUpnFieldToUsers extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $bridge->contentTypeDeleteField('user', 'user', 'teams');
        $bridge->contentTypeCreateField(
            'users',
            'upn',
            [
                'name' => 'upn',
                'type' => BridgeContentType::TEXT_FIELD,
                'editable' => false,
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'weight' => 10,
                'title' => [
                    'fr' => 'Upn',
                ],
                'widget' => [
                    'type' => BridgeContentType::STRING_WIDGET,
                    'hidden' => true,
                ],
                'settings' => [
                    'cardinality' => 1,
                ],
            ]
        );
    }

    public function down(): void
    {
    }
}
