<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Notify\Models\NotificationType;

class FixIsFeaturedNotif extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up(): void
    {
        NotificationType::where([
            'via' => 'web',
            'default' => true,
            'event' => 'Inside\Content\Events\ContentCreatedEvent',
            'model' => 'Inside\Content\Models\Contents\News',
            'action' => 'create',
            'condition' => 'is_featured:1|status:1',
            'multiple' => false,
            'profile' => true,
        ])->each(function ($notificationType) {
            $notificationType->role = false;
            $notificationType->save();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down(): void
    {
        //
    }
}
