<?php


use Illuminate\Database\Migrations\Migration;
use Inside\Host\Bridge\BridgeContentType;

class AddIsFlashToNews extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        // boolen
        // is_flash
        $field = [
                'name' => 'is_flash',
                'searchable' => false,
                'translatable' => false,
                'search_result_field' => false,
                'required' => false,
                'default' => false,
                'weight' => 8,
                'title' => [
                    'fr' => 'Afficher en popin',
                ],
                'widget' => [
                    'type' => BridgeContentType::BOOLEAN_CHECKBOX_WIDGET,
                    'settings' => [
                        'display_label' => true,
                    ],
                    'weight' => 8,
                    'group' => 'group_advanced_options',
                ],
                'type' => BridgeContentType::BOOLEAN_FIELD,
                'settings' => [
                    'cardinality' => 1,
                ],
        ];

        $bridge->contentTypeCreateOrUpdateField('news', 'is_flash', $field);
    }

    public function down(): void
    {
    }
}
