<?php

use Inside\Host\Bridge\BridgeContentType;

$weight = 1;

return [
    'options' => [
        'translatable' => false,
        'searchable' => true,
        'global_searchable' => false,
        'aliasable' => true,
        'listing_type' => 'content',
        'permissible' => true,
        'categorizable' => false,
        'name' => 'pages',
        'title' => [
            'fr' => 'Pages'
        ],
    ],
    'fields' => [
        [
            'name' => 'content',
            'searchable' => true,
            'translatable' => false,
            'default' => null,
            'search_result_field' => false,
            'required' => true,
            'weight' => $weight,
            'title' => [
                'fr' => 'Contenu'
            ],
            'description' => [
                'fr' => ''
            ],
            'widget' => [
                'type' => BridgeContentType::SECTION_WIDGET,
                'settings' => [
                    'title' => 'Paragraph',
                    'title_plural' => 'Paragraphs',
                    'edit_mode' => 'closed',
                    'add_mode' => 'dropdown',
                    'form_display_mode' => 'default',
                    'default_paragraph_type' => '_none',
                ],
                'weight' => $weight++,
            ],
            'type' => BridgeContentType::SECTION_FIELD,
            'settings' => [
                'target_type' => [
                    'accordion',
                    'call_to_action',
                    'file',
                    'files',
                    'html',
                    'image',
                    'map',
                    'slide',
                    'slider',
                    'text',
                    'text_with_image',
                    'tweet',
                    'video',
                ],
                'cardinality' => -1,
            ],
        ],
        [
            'name'                  => 'banner',
            'searchable'            => false,
            'translatable'          => false,
            'default'               => false,
            'search_result_field'   => false,
            'required'              => false,
            'weight'                => $weight,
            'title'                 => [
                'fr' => 'Bannière',
            ],
            'description'           => [
                'fr' => '',
            ],
            'widget'                => [
                'type'      => BridgeContentType::IMAGE_WIDGET,
                'settings'  => [
                    'progress_indicator'  => 'throbber',
                    'preview_image_style' => 'thumbnail',
                ],
                'weight'    => $weight++,
            ],
            'type'                  => BridgeContentType::IMAGE_FIELD,
            'settings'              => [
                'uri_scheme'      => 'public',
                'default_image'   => [
                    'uuid'    => '',
                    'alt'     => '',
                    'title'   => '',
                    'width'   => null,
                    'height'  => null,
                ],
                'target_type'     => 'file',
                'display_field'   => false,
                'display_default' => false,
                'cardinality'     => 1,
            ],
        ],
    ],
];
