import ToolsListingPage from '../pages/tools/ToolsListingPage'

import SpacesPage from '../pages/spaces/SpacesPage'
import SpacesPagesPage from '../pages/spaces/SpacesPagesPage'

import MeryPages from '../pages/mery/MeryPages'
import MeryCategoriesPage from '../pages/mery/MeryCategoriesPage'

import { fetchSpace, fetchSpacePage } from '../fetch/spaces'
import { fetchLinkPage } from '../fetch/linkPages'
import { fetchMeryCategories, fetchMeryPages } from '../fetch/meryPage'

import { withFetch } from 'inside-collection/hocs'

export default [
  {
    name: 'HomePage',
    component: () => import('../pages/HomePage'),
    meta: { disabled: false }
  },
  {
    name: 'GedPage',
    meta: { disabled: false },
    component: () => import('../pages/ged/GedPage')
  },
  {
    name: 'ToolsPage',
    meta: { disabled: true }
  },
  {
    name: 'ToolsListingPage',
    path: {
      fr: '/outils/:slug'
    },
    component: withFetch(ToolsListingPage, { size: 'xxl', watch: true })(fetchLinkPage)
  },
  {
    name: 'SpacesPage',
    path: {
      fr: '/espace/:slug'
    },
    component: withFetch(SpacesPage, { size: 'xxl', watch: true })(fetchSpace)
  },
  {
    name: 'SpacesPagesPage',
    path: {
      fr: '/page-espace/:slug'
    },
    component: withFetch(SpacesPagesPage, { size: 'xxl', watch: true })(
      fetchSpacePage
    )
  },
  {
    name: 'LifestylePage',
    meta: { customSlug: 'lifestyle' },
    path: {
      fr: '/vie-pratique'
    },
    component: () => import('../pages/lifestyle/LifestylePage')
  },
  {
    name: 'Legacy_Lifestyle_AuQuotidien',
    path: '/au-quotidien',
    redirect: { name: 'LifestylePage' }
  },
  {
    name: 'Legacy_Lifestyle_AuxAlentours',
    path: '/aux-alentours',
    redirect: { name: 'LifestylePage' }
  },
  {
    name: 'NewsListingPage',
    meta: { disabled: false },
    props: { filtersInput: 'selectbox' }
  },
  {
    name: 'NewsPage',
    meta: { disabled: false }
  },
  {
    name: 'EventsCalendarPage',
    meta: { disabled: false }
  },
  {
    name: 'EventPage',
    meta: { disabled: false }
  },
  {
    name: 'DirectoryPage',
    meta: { disabled: false },
    component: () => import('../pages/directory/DirectoryPage')
  },
  {
    name: 'MeryPage',
    path: '/mery-21',
    component: () => import('../pages/mery/MeryPage')
  },
  {
    name: 'MeryCategoriesPage',
    path: '/mery-21/:slug',
    component: withFetch(MeryCategoriesPage, { size: 'xxl', watch: true })(
      fetchMeryCategories
    )
  },
  {
    name: 'MeryPages',
    path: '/mery-21/:slug/:page',
    component: withFetch(MeryPages, { size: 'xxl', watch: true })(
      fetchMeryPages
    )
  }
]
