import { http } from '@inside-library/helpers/Http'

export default {
  spaces: {
    add: ({ data }) => ({
      name: 'SpacesPage',
      params: {
        slug: data.slug[0]
      }
    })
  },
  spacesPages: {
    fields: [{ spaces_pages_categories: [{ spaces: ['slug'] }] }],
    add: ({ data }) => ({
      name: 'SpacesPagesPage',
      params: {
        slug: data.slug[0]
      }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPage',
      params: {
        slug: data.spaces_pages_categories.data[0].spaces.data[0].slug[0]
      }
    })
  },
  spacesPagesCategories: {
    fields: [{ spaces: ['slug'] }],
    add: async ({ data }) => ({
      name: 'SpacesPage',
      params: {
        slug: data.spaces.data[0].slug[0]
      }
    }),
    delete: ({ data }) => ({
      name: 'SpacesPage',
      params: {
        slug: data.spaces.data[0].slug[0]
      }
    })
  },
  lifestyleContents: {
    add: () => ({ name: 'LifestylePage' }),
    delete: () => ({ name: 'LifestylePage' })
  },
  lifestyleCategories: {
    add: () => ({ name: 'LifestylePage' }),
    delete: () => ({ name: 'LifestylePage' })
  },
  linkPages: {
    add: async ({ data }) => {
      const { data: linkPages } = await http.get('content/link_pages', {
        fields: [
          'uuid',
          'slug'
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': data.uuid
        }
      })

      return {
        name: 'ToolsListingPage',
        params: { slug: linkPages[0].slug[0] }
      }
    }
  },
  tools: {
    add: async ({ data }) => {
      const { data: toolCategories } = await http.get('content/tools', {
        fields: [
          'uuid',
          'title',
          {
            tools_categories: [
              { link_pages: ['uuid', 'title', 'slug'] }
            ]
          }
        ],
        filters: {
          'uuid:eq': data.uuid
        }
      })

      return {
        name: 'ToolsListingPage',
        params: {
          slug: toolCategories?.[0]?.tools_categories?.data?.[0]
                  ?.link_pages?.data?.[0]?.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: toolCategories } = await http.get('content/tools', {
        fields: [
          'uuid',
          'title',
          {
            tools_categories: [
              { link_pages: ['uuid', 'title', 'slug'] }
            ]
          }
        ],
        filters: {
          'status:eq': 1,
          'uuid:eq': uuid
        }
      })

      return {
        name: 'ToolsListingPage',
        params: {
          slug: toolCategories?.[0]?.tools_categories?.data?.[0]
                  ?.link_pages?.data?.[0]?.slug[0]
        }
      }
    },
    globalSearch: ({ vm, data, params }) => ({
      action: () => {
        vm.triggerModal(
          'tools',
          'fetch',
          {
            item: data,
            content: data.content_type || 'tools'
          },
          { layout: 'right', transition: 'fadeInLeft', useUrlParams: true }
        )
      }
    })
  },
  toolsCategories: {
    add: async ({ data }) => {
      const { data: toolCategories } = await http.get(
        'content/tools_categories',
        {
          fields: [
            'uuid',
            'title',
            { link_pages: ['uuid', 'title', 'slug'] }
          ],
          filters: {
            'uuid:eq': data.uuid
          }
        }
      )

      return {
        name: 'ToolsListingPage',
        params: {
          slug: toolCategories?.[0]?.link_pages?.data?.[0]?.slug[0]
        }
      }
    },
    delete: async ({ uuid }) => {
      const { data: toolCategories } = await http.get(
        'content/tools_categories',
        {
          fields: [
            'uuid',
            'title',
            { link_pages: ['uuid', 'title', 'slug'] }
          ],
          filters: {
            'status:eq': 1,
            'uuid:eq': uuid
          }
        }
      )

      return {
        name: 'ToolsListingPage',
        params: {
          slug: toolCategories?.[0]?.link_pages?.data?.[0]?.slug[0]
        }
      }
    }
  },
  meryCategories: {
    add: ({ data }) => ({
      name: 'MeryCategoriesPage',
      params: { slug: data.slug[0] }
    }),
    delete: () => ({ name: 'MeryPage' })
  },
  meryPages: {
    add: async ({ data, vm }) => {
      const { data: meryCategories } = await http.get('content/mery_pages', {
        fields: [
          'uuid',
          {
            mery_categories: {
              fields: ['uuid', 'slug']
            }
          }
        ],
        filters: {
          'status:eq': 1,
          'slug:eq': data.slug[0]
        }
      })

      return {
        name: 'MeryPages',
        params: {
          slug: meryCategories[0].mery_categories.data[0].slug[0],
          page: data.slug[0]
        }
      }
    },
    delete: () => ({ name: 'MeryCategoriesPage' })
  }
}
